/* Copyright (C) 2015-2018 RealVNC Ltd.  All Rights Reserved.
 */

#ifndef LOG_H_32fcfbef_6442_4d98_88d6_62efeee4abac
#define LOG_H_32fcfbef_6442_4d98_88d6_62efeee4abac

#include <vnccommon/Clock.h>
#include <vnccommon/Mutex.h>
#include <vnccommon/StaticUtils.h>

#include <string>

#include <stdio.h>
#include <stdarg.h>

/**
 * \cond VNCCOMMON
 */
namespace vnccommon
{

enum LogLevel
{
    LOG_DEBUG = 100,
    LOG_INFO = 30,
    LOG_WARNING = 20,
    LOG_ERROR = 10,
    LOG_FATAL_ERROR = 0
};

class LogHandler
{
public:
    class Tagged
    {
    public:
        Tagged(LogHandler& logHandler, const std::string& tag);

        VNCCOMMON_ATTRIBUTE_FORMAT(2, 3)
        void debug(const char* format, ...);

        VNCCOMMON_ATTRIBUTE_FORMAT(2, 3)
        void info(const char* format, ...);

        VNCCOMMON_ATTRIBUTE_FORMAT(2, 3)
        void warning(const char* format, ...);

        VNCCOMMON_ATTRIBUTE_FORMAT(2, 3)
        void error(const char* format, ...);

        Tagged appendTag(const std::string& tag);

    private:
        LogHandler& mLogHandler;
        const std::string mTag;
    };

public:
    Tagged tag(const std::string& tag);

    void logV(LogLevel level, const char* tag, const char* format, va_list ap);

    virtual ~LogHandler();

public:
    virtual void writeRaw(LogLevel level, const char* tag, const char* text) = 0;
};

class OStreamLogHandler : public LogHandler
{
public:
    OStreamLogHandler(std::ostream& stream);
    virtual void writeRaw(LogLevel level, const char* tag, const char* text);
private:
    const MonotonicTimestamp mStartTime;
    std::ostream &mStream;
    Mutex mMutex;
};

} // end of namespace vnccommon
/**
 * \endcond
 */

#endif // LOG_H_32fcfbef_6442_4d98_88d6_62efeee4abac

